unit FileInfo;
{
  File Information class
  Copyright (c) 1996, by Philip Stevenson
}
interface

uses WinTypes, WinProcs, SysUtils;

const
  DATE_TIME_FORMAT = 'dd-MMM-yyyy hh:mm:ss';

type
  TFileInfo = class
  private
    Frec: TSearchRec;
    FFullName: string;
    FFileName: string;
    FFilePath: string;
    FDateTime: TDateTime;
    function GetFileTime: TDateTime;
    function GetShowFileStats: string;
    function GetFileInfo: boolean;
    function GetFileTimeStr: string;
  public
    constructor Create(AFilename: string);
    property FileTime: TDateTime read GetFileTime;
    property ShowFileStats: string read GetShowFileStats;
    property FileInfo: boolean read GetFileInfo;
    property FileTimeStr: string read GetFileTimeStr;
    property FileName: string read FFileName;
    property FilePath: string read FFilePath;
  end;

  function AddBackSlash(const FDir: string): string;

implementation

  function AddBackSlash(const FDir: string): string;
  begin
    Result := FDir;
    if (length(FDir) < 255) and (FDir[length(FDir)] <> '\')then
      Result := Result+'\'
  end;

  { TFileInfo methods }

constructor TFileInfo.Create(AFilename: string);
begin
  FFileName := ExtractFileName(AFilename);
  FFilePath := ExtractFilePath(AFilename);
  FFullName := AFilename;
end;

function TFileInfo.GetFileInfo: boolean;
{-Returns True if file is found}
begin
  Result := FindFirst(FFullName, faAnyFile, Frec) = 0;
  FindClose(Frec);
end;

function TFileInfo.GetFileTime: TDateTime;
{-Show date time of file selected}
begin
  if GetFileInfo then
    Result := FileDateToDateTime(Frec.Time)
  else
    Result := 0;
end;

function TFileInfo.GetFileTimeStr: string;
{-Show date time of file selected}
begin
  FDateTime := FileTime;
  if FDateTime <> 0 then
  try
    Result := FormatDateTime(DATE_TIME_FORMAT, FDateTime);
  except {illegal date or time}
    Result := 'BAD FILE DATE';
  end
  else
    Result := 'DATE UNKNOWN'
end;

function TFileInfo.GetShowFileStats: string;
{-Return formatted string w/ file info}
var
  AttrStr, S: string;
begin
  Result := '';
  S := GetFileTimeStr;
  if FDateTime = 0 then
    exit;
  { Formatting for attribute string }
  with Frec do
  begin
    AttrStr := '----';
    if Attr and faReadOnly <> 0 then
      attrstr[1] := 'R';
    if Attr and faArchive <> 0 then
      attrstr[2] := 'A';
    if Attr and faSysFile <> 0 then
      attrstr[3] := 'S';
    if Attr and faHidden <> 0 then
      attrstr[4] := 'H';
  end;
  Result := Format('%12s  Size: %6s  Date: %s  %s',
    [Frec.Name, FormatFloat(',##########0', Frec.Size), S, AttrStr]);
end;

end.
